package netsdk.callback.impl;
import java.io.File;
import java.io.IOException;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;

import netsdk.callback.SUBSCRIBE_CALLBACK;
import netsdk.lib.CommonFunctions;
import netsdk.lib.ErrorCodeAndConst;
import netsdk.struct.*;

public class SUBSCRIBE_CALLBACK_IMPL implements SUBSCRIBE_CALLBACK{

	@Override
	public void invoke(NativeLong lUserID, int dwCommand, Pointer pBuf, int dwBufLen, Pointer pUser) {
		
		DateTimeFormatter format = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
		DateTime ctime;
		String folerPath;
		int restLen = dwBufLen;
		int offSetLen = 0;
		int len = 0;
		switch (dwCommand) {
		case ErrorCodeAndConst.NET_SDK_N9000_ALARM_TYPE_PASSLINE:
		{
			NET_SDK_IVE_PASSLINECOUNT_T passlineInfo = new NET_SDK_IVE_PASSLINECOUNT_T();
			CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, passlineInfo);
		}
		
		case ErrorCodeAndConst.NET_SDK_N9000_ALARM_TYPE_VEHICE:
			//NET_SDK_IVE_VEHICE_HEAD_INFO+[NET_SDK_IVE_VEHICE_ITEM_INFO+源数据]+[NET_SDK_IVE_VEHICE_ITEM_INFO+车牌数据]+...+[NET_SDK_IVE_VEHICE_ITEM_INFO+车牌数据]             
			
			NET_SDK_IVE_VEHICE_HEAD_INFO vehiceHeadInfo = new NET_SDK_IVE_VEHICE_HEAD_INFO();
            len = vehiceHeadInfo.size();
            if(dwBufLen < len)
            {
                break;
            }                
			CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, vehiceHeadInfo);
			vehiceHeadInfo.read();
			offSetLen += len;//地址偏移
			restLen -= len;//剩余长度
			
			ctime = DateTime.parse(CommonFunctions.stampToDate(vehiceHeadInfo.absoluteTime), format); 
			folerPath = CreatePath(lUserID.intValue(), ctime);
            
            int cntVheCle = vehiceHeadInfo.item_cnt;

            if (cntVheCle > 0)
            {
            	System.out.println("车牌识别");
	            for(int i = 0;i< cntVheCle;i++)
	            {
		            NET_SDK_IVE_VEHICE_ITEM_INFO vehicleinfo = new NET_SDK_IVE_VEHICE_ITEM_INFO();
		            CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, vehicleinfo);
		            vehicleinfo.read();		            
		            offSetLen += vehicleinfo.size();//偏移量
				            					            					
		            if (vehicleinfo.jpeg_len > 0)
		            {
			            if(i == 0)//第1张是源图片
			            {
			            	byte[] data = pBuf.getByteArray(offSetLen, vehicleinfo.jpeg_len);
			            	
			            	File srcPic = new File(folerPath + "\\vehicleSrc.jpg");//
							try {
								srcPic.createNewFile();
								CommonFunctions.writeFileByBytes(folerPath + "\\vehicleSrc.jpg",data,false);//数据写入文件中
							} catch (IOException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
							offSetLen += vehicleinfo.jpeg_len;//地址偏移
							restLen -= vehicleinfo.jpeg_len;//剩余长度		
			            	                          
			            }
			            else//其他是车牌照片
			            {
		            		byte[] data = pBuf.getByteArray(offSetLen, vehicleinfo.jpeg_len);
			            	
			            	File srcPic = new File(folerPath + "\\vehiclePlate.jpg");//
							try {
								srcPic.createNewFile();
								CommonFunctions.writeFileByBytes(folerPath + "\\vehiclePlate.jpg",data,false);//数据写入文件中
							} catch (IOException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
							offSetLen += vehicleinfo.jpeg_len;//地址偏移
							restLen -= vehicleinfo.jpeg_len;//剩余长度		
			            }
				
		            }
		            
		            if (vehicleinfo.jpeg_vir_len > vehicleinfo.jpeg_len)
		            {
		            	offSetLen += (int)(vehicleinfo.jpeg_vir_len - vehicleinfo.jpeg_len);
		            }											
	            }
            }
            break;
			
		case ErrorCodeAndConst.NET_SDK_N9000_ALARM_TYPE_VFD://人脸检测
			 /*NET_DVR_IVE_VFD_RESULT_HEAD_T+
            [NET_DVR_IVE_VFD_RESULT_DATA_INFO_T+源数据]+
            [NET_DVR_IVE_VFD_RESULT_FACE_DATA_INFO_T+人脸数据+人脸特征值]+...+
            [NET_DVR_IVE_VFD_RESULT_FACE_DATA_INFO_T+人脸数据+人脸特征值*/
			
			NET_DVR_IVE_VFD_RESULT_HEAD_T head = new NET_DVR_IVE_VFD_RESULT_HEAD_T();
			len = head.size();			
			CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, head);
			head.read();
			offSetLen += len;//地址偏移
			restLen -= len;//剩余长度
			
			
			ctime = DateTime.parse(CommonFunctions.stampToDate(head.time), format); 
			folerPath = CreatePath(lUserID.intValue(), ctime);
			
			NET_DVR_IVE_VFD_RESULT_DATA_INFO_T src = new NET_DVR_IVE_VFD_RESULT_DATA_INFO_T();
			len = src.size();			
			if (restLen < len){
				break;
			}
			CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, src);
			src.read();
			offSetLen += len;//地址偏移
			restLen -= len;//剩余长度
			if (restLen < src.dataLen){
				break;
			}
			if (src.dataLen > 0) {
				//原始背景图片
				byte[] data = pBuf.getByteArray(offSetLen, src.dataLen);
				File srcPic = new File(folerPath + "\\src.jpg");//
				try {
					srcPic.createNewFile();
					CommonFunctions.writeFileByBytes(folerPath + "\\src.jpg",data,false);//数据写入文件中
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				offSetLen += src.dataLen;//地址偏移
				restLen -= src.dataLen;//剩余长度				
			}
			
			NET_DVR_IVE_VFD_RESULT_FACE_DATA_INFO_T face = new NET_DVR_IVE_VFD_RESULT_FACE_DATA_INFO_T();
			len = face.size();	
			if (restLen < head.faceCnt * len){
				break;
			}
			for (int i = 0; i < head.faceCnt; i++) {
				CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, face);
				face.read();
				offSetLen += len;//地址偏移
				restLen -= len;//剩余长度
				if(face.temperature > 0) {
					System.out.println("the temperature is:" + face.temperature / 100);
					System.out.println("size is :" + face.size());
				}
				
				if (face.stFaceImgData.dataLen > 0) {
					//人脸图片
					byte[] data = pBuf.getByteArray(offSetLen, face.stFaceImgData.dataLen);
					
					File facePic = new File(folerPath + "\\face" + i + ".jpg");//
					try {
						facePic.createNewFile();
						CommonFunctions.writeFileByBytes(folerPath + "\\face" + i + ".jpg", data, false);//数据写入文件中
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					offSetLen += face.stFaceImgData.dataLen;//地址偏移
					restLen -= face.stFaceImgData.dataLen;//剩余长度		
				}
			}						
			break;
		case 17://人脸比对
			//pBuf为NET_SDK_IVE_BASE_INFO+NET_SDK_IVE_PICTURE_INFO+图片数据(实时)+NET_SDK_IVE_PICTURE_INFO+图片数据(相册)
	        /*	----------------------
	        |	NET_SDK_IVE_BASE_INFO	|
	        -------------------------
	        |	NET_SDK_IVE_PICTURE_INFO	|
	        -------------------------
	        |	byte[]图片数据(实时)长度：NET_SDK_IVE_PICTURE_INFO.iPicSize		|
	        -------------------------
	        |	NET_SDK_IVE_PICTURE_INFO	|
	        -------------------------
	        |	byte[]图片数据(相册)长度：NET_SDK_IVE_PICTURE_INFO.iPicSize		|
	        -------------------------
	        |	NET_SDK_IVE_PICTURE_INFO	|
	        -------------------------
	        |	byte[]原始背景图片数据(相册)长度：NET_SDK_IVE_PICTURE_INFO.iPicSize		|
	        -------------------------*/
			int restLen1 = dwBufLen;
			NET_SDK_IVE_BASE_INFO baseInfo = new  NET_SDK_IVE_BASE_INFO();
			int len1 = baseInfo.size();
			int offSetLen1 = 0;			 
			 //int aa = Long.SIZE / 8;
			CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen1, baseInfo);
			baseInfo.read();
			offSetLen1 += len1;//地址偏移
			restLen1 -= len1;//剩余长度
			
			//DateTimeFormatter format1 = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
			//DateTime ctime1 = DateTime.parse(CommonFunctions.stampToDate(baseInfo.i64SnapTime), format1); 
			//String folerPath1 = CreatePath(lUserID.intValue(), ctime1);
			System.out.println("温度: " + baseInfo.temperature / 100);
			
			
			NET_SDK_IVE_PICTURE_INFO pictureInfo = new NET_SDK_IVE_PICTURE_INFO();
			len1 = pictureInfo.size();
			if(restLen1 < len1) {
				break;
			}
			CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen1, pictureInfo);
			pictureInfo.read();
			offSetLen1 += len1;//地址偏移
			restLen1 -= len1;//剩余长度
			if(restLen1 < pictureInfo.iPicSize) {
				break;
			}			 			
			//CommonFunctions.GetPointerDataToStruct(pBuf, 556, pictureInfo);
			 
			if (pictureInfo.iPicSize > 0) {//实时抓拍图片
				//System.out.println("抓拍时间" + CommonFunctions.stampToDate(baseInfo.i64SnapTime));
				System.out.println("抓拍id: " + baseInfo.iSnapPicId);
				System.out.println("相似度: " + baseInfo.iSimilarity);
				
				//byte[] data = pBuf.getByteArray(baseInfo.size() + pictureInfo.size(), pictureInfo.iPicSize);//图片数据(实时抓拍到的)，想办法保存到本地或者显示
				System.out.println("相似度: " + baseInfo.iSimilarity);
				offSetLen1 += pictureInfo.iPicSize;//地址偏移
				restLen1 -= pictureInfo.iPicSize;//剩余长度
			}
			
			
			if(restLen1 < len1) {
				break;
			}
			pictureInfo = new NET_SDK_IVE_PICTURE_INFO();
			CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen1, pictureInfo);
			pictureInfo.read();
			offSetLen1 += len1;//地址偏移
			restLen1 -= len1;//剩余长度
			if(restLen1 < pictureInfo.iPicSize) {
				break;
			}			 						 
			if (pictureInfo.iPicSize > 0) {//相册图片				
				offSetLen1 += pictureInfo.iPicSize;//地址偏移
				restLen1 -= pictureInfo.iPicSize;//剩余长度
			}
			
			if(restLen1 < len1) {
				break;
			}
			pictureInfo = new NET_SDK_IVE_PICTURE_INFO();
			CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen1, pictureInfo);
			pictureInfo.read();
			offSetLen1 += len1;//地址偏移
			restLen1 -= len1;//剩余长度
			if(restLen1 < pictureInfo.iPicSize) {
				break;
			}			 						 
			if (pictureInfo.iPicSize > 0) {//原始背景图片				
				offSetLen1 += pictureInfo.iPicSize;//地址偏移
				restLen1 -= pictureInfo.iPicSize;//剩余长度
			}
			 			
			break;
		}
		 
		 
        
	}

	private String CreatePath(int userId, DateTime dt)
    {
        String tempPath = "D:\\" + userId + "\\" + dt.getYear() + AddZero(dt.getMonthOfYear()) + AddZero(dt.getDayOfYear());
        File filePath = new File(tempPath);//
        if(!filePath.exists()) {
        	filePath.mkdirs();
        }                   
        return tempPath;
    }
	private static String AddZero(int time)
    {
        int a = time;        
        return a > 9 ? String.valueOf(a) : "0" + a;
    }
}
